PHP

<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// ... rest of your code



<?php
header('Content-Type: application/json');

$dbFile = 'quotation_database.csv';
$destFolder = './destinations/';
$action = $_GET['action'] ?? '';

// 1. Initial Setup Data
if ($action == 'getInitialData') {
    $files = is_dir($destFolder) ? array_diff(scandir($destFolder), array('.', '..')) : [];
    $destinations = array_values(array_filter($files, function($f) {
        return strpos($f, '.csv') !== false;
    }));
    
    $ops = []; $sales = [];
    if (file_exists($dbFile)) {
        if (($handle = fopen($dbFile, "r")) !== FALSE) {
            fgetcsv($handle); 
            while (($data = fgetcsv($handle, 2000, ",")) !== FALSE) {
                if (!empty($data[2])) $sales[] = $data[2]; 
                if (!empty($data[3])) $ops[] = $data[3];   
            }
            fclose($handle);
        }
    }
    echo json_encode([
        'destinations' => $destinations,
        'staff' => ['ops' => array_values(array_unique($ops)), 'sales' => array_values(array_unique($sales))]
    ]);
    exit;
}

// 2. Fetch Pricing Matrix
if ($action == 'getDestData') {
    $file = $destFolder . $_GET['file'];
    $rows = [];
    if (file_exists($file) && ($handle = fopen($file, "r")) !== FALSE) {
        while (($data = fgetcsv($handle, 2000, ",")) !== FALSE) { $rows[] = $data; }
        fclose($handle);
    }
    echo json_encode(['headers' => $rows[0] ?? [], 'rows' => array_slice($rows, 1)]);
    exit;
}

// 3. Save Quote
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $isNew = !file_exists($dbFile);
    $fp = fopen($dbFile, 'a');
    if ($isNew) {
        fputcsv($fp, ["Timestamp", "Ref ID", "Sales", "Ops", "Dest", "Start", "End", "Pax", "Hotels", "Services", "Itinerary", "Total"]);
    }
    fputcsv($fp, [
        date('Y-m-d H:i:s'), $data['id'], $data['sales'], $data['ops'], 
        $data['destination'], $data['startDate'], $data['endDate'], 
        $data['pax'], $data['hotels'], $data['services'], $data['itinerary'], $data['total']
    ]);
    fclose($fp);
    echo json_encode(['status' => 'success', 'message' => 'Quote saved successfully!']);
    exit;
}